/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Vector;
import jp.gr.java_conf.dangan.util.lha.CompressMethod;
import jp.gr.java_conf.dangan.util.lha.LhaHeader;
import jp.gr.java_conf.dangan.util.lha.LhaProperty;

public class LhaFile {
    private RandomAccessFile archive;
    private Object LastAccessObject;
    private Vector headers;
    private Vector entryPoint;
    private Hashtable hash;
    private Vector duplicate;
    private Properties property;

    private LhaFile() {
    }

    public LhaFile(String filename) throws IOException {
        Properties property = LhaProperty.getProperties();
        RandomAccessFile file = new RandomAccessFile(filename, "r");
        this.constructerHelper(file, property, false);
    }

    public LhaFile(String filename, Properties property) throws IOException {
        RandomAccessFile file = new RandomAccessFile(filename, "r");
        this.constructerHelper(file, property, false);
    }

    public LhaFile(File filename) throws IOException {
        Properties property = LhaProperty.getProperties();
        RandomAccessFile file = new RandomAccessFile(filename, "r");
        this.constructerHelper(file, property, false);
    }

    public LhaFile(File filename, Properties property) throws IOException {
        RandomAccessFile file = new RandomAccessFile(filename, "r");
        this.constructerHelper(file, property, false);
    }

    public LhaFile(RandomAccessFile file) throws IOException {
        Properties property = LhaProperty.getProperties();
        this.constructerHelper(file, property, false);
    }

    public LhaFile(RandomAccessFile file, boolean rescueMode) throws IOException {
        Properties property = LhaProperty.getProperties();
        this.constructerHelper(file, property, rescueMode);
    }

    public LhaFile(RandomAccessFile file, Properties property) throws IOException {
        this.constructerHelper(file, property, false);
    }

    public LhaFile(RandomAccessFile file, Properties property, boolean rescueMode) throws IOException {
        this.constructerHelper(file, property, rescueMode);
    }

    private void constructerHelper(RandomAccessFile file, Properties property, boolean rescueMode) throws IOException {
        this.headers = new Vector();
        this.entryPoint = new Vector();
        file.seek(0L);
        CachedRandomAccessFileInputStream archive = new CachedRandomAccessFileInputStream(file);
        byte[] HeaderData = LhaHeader.getFirstHeaderData(archive);
        while (HeaderData != null) {
            LhaHeader header = LhaHeader.createInstance(HeaderData, property);
            this.headers.addElement(header);
            this.entryPoint.addElement(new Long(archive.position()));
            if (!rescueMode) {
                archive.skip(header.getCompressedSize());
                HeaderData = LhaHeader.getNextHeaderData(archive);
                continue;
            }
            HeaderData = LhaHeader.getFirstHeaderData(archive);
        }
        archive.close();
        this.hash = new Hashtable();
        this.duplicate = new Vector();
        int i = 0;
        while (i < this.headers.size()) {
            LhaHeader header = (LhaHeader)this.headers.elementAt(i);
            if (!this.hash.containsKey(header.getPath())) {
                this.hash.put(header.getPath(), new Integer(i));
            } else {
                this.duplicate.addElement(new Integer(i));
            }
            ++i;
        }
        this.archive = file;
        this.property = (Properties)property.clone();
    }

    public InputStream getInputStream(LhaHeader header) {
        int index = this.getIndex(header);
        if (index >= 0) {
            long start = (Long)this.entryPoint.elementAt(index);
            long len = header.getCompressedSize();
            RandomAccessFileInputStream in = new RandomAccessFileInputStream(start, len);
            return CompressMethod.connectDecoder(in, header.getCompressMethod(), this.property, header.getOriginalSize());
        }
        return null;
    }

    public InputStream getInputStream(String name) {
        if (this.hash.containsKey(name)) {
            int index = (Integer)this.hash.get(name);
            LhaHeader header = (LhaHeader)this.headers.elementAt(index);
            long start = (Long)this.entryPoint.elementAt(index);
            long len = header.getCompressedSize();
            RandomAccessFileInputStream in = new RandomAccessFileInputStream(start, len);
            return CompressMethod.connectDecoder(in, header.getCompressMethod(), this.property, header.getOriginalSize());
        }
        return null;
    }

    public InputStream getInputStreamWithoutExtract(LhaHeader header) {
        int index = this.getIndex(header);
        if (index >= 0) {
            long start = (Long)this.entryPoint.elementAt(index);
            long len = header.getCompressedSize();
            return new RandomAccessFileInputStream(start, len);
        }
        return null;
    }

    public InputStream getInputStreamWithoutExtract(String name) {
        if (this.hash.containsKey(name)) {
            int index = (Integer)this.hash.get(name);
            LhaHeader header = (LhaHeader)this.headers.elementAt(index);
            long start = (Long)this.entryPoint.elementAt(index);
            long len = header.getCompressedSize();
            return new RandomAccessFileInputStream(start, len);
        }
        return null;
    }

    public int size() {
        return this.headers.size();
    }

    public Enumeration entries() {
        if (this.archive != null) {
            return new HeaderEnumeration();
        }
        throw new IllegalStateException();
    }

    public LhaHeader[] getEntries() {
        LhaHeader[] headers = new LhaHeader[this.headers.size()];
        int i = 0;
        while (i < this.headers.size()) {
            headers[i] = (LhaHeader)((LhaHeader)this.headers.elementAt(i)).clone();
            ++i;
        }
        return headers;
    }

    public void close() throws IOException {
        this.archive.close();
        this.archive = null;
        this.LastAccessObject = null;
        this.headers = null;
        this.entryPoint = null;
        this.hash = null;
        this.property = null;
        this.duplicate = null;
    }

    private int getIndex(LhaHeader target) {
        int index = (Integer)this.hash.get(target.getPath());
        LhaHeader header = (LhaHeader)this.headers.elementAt(index);
        if (!LhaFile.equal(header, target)) {
            boolean match = false;
            int i = 0;
            while (i < this.duplicate.size() && !match) {
                index = (Integer)this.duplicate.elementAt(i);
                header = (LhaHeader)this.headers.elementAt(index);
                if (LhaFile.equal(header, target)) {
                    match = true;
                }
                ++i;
            }
            if (match) {
                return index;
            }
            return -1;
        }
        return index;
    }

    private static boolean equal(LhaHeader header1, LhaHeader header2) {
        return header1.getPath().equals(header2.getPath()) && header1.getCompressMethod().equals(header2.getCompressMethod()) && header1.getLastModified().equals(header2.getLastModified()) && header1.getCompressedSize() == header2.getCompressedSize() && header1.getOriginalSize() == header2.getOriginalSize() && header1.getCRC() == header2.getCRC() && header1.getOSID() == header2.getOSID() && header1.getHeaderLevel() == header2.getHeaderLevel();
    }

    private static class CachedRandomAccessFileInputStream
    extends InputStream {
        private RandomAccessFile archive;
        private byte[] cache;
        private int cachePosition;
        private int cacheLimit;
        private boolean markPositionIsInCache;
        private byte[] markCache;
        private int markCachePosition;
        private int markCacheLimit;
        private long markPosition;

        public CachedRandomAccessFileInputStream(RandomAccessFile file) {
            this.archive = file;
            this.cache = new byte[1024];
            this.cachePosition = 0;
            this.cacheLimit = 0;
        }

        @Override
        public int read() throws IOException {
            if (this.cachePosition < this.cacheLimit) {
                return this.cache[this.cachePosition++] & 0xFF;
            }
            this.fillCache();
            if (this.cachePosition < this.cacheLimit) {
                return this.cache[this.cachePosition++] & 0xFF;
            }
            return -1;
        }

        @Override
        public int read(byte[] buffer) throws IOException {
            return this.read(buffer, 0, buffer.length);
        }

        @Override
        public int read(byte[] buffer, int index, int length) throws IOException {
            int requested = length;
            while (length > 0) {
                if (this.cacheLimit <= this.cachePosition) {
                    this.fillCache();
                    if (this.cacheLimit <= this.cachePosition) {
                        if (requested != length) break;
                        return -1;
                    }
                }
                int copylen = Math.min(length, this.cacheLimit - this.cachePosition);
                System.arraycopy(this.cache, this.cachePosition, buffer, index, copylen);
                index += copylen;
                length -= copylen;
                this.cachePosition += copylen;
            }
            return requested - length;
        }

        @Override
        public long skip(long length) throws IOException {
            long skiplen;
            long avail;
            long requested = length;
            if (this.cachePosition < this.cacheLimit) {
                avail = (long)this.cacheLimit - (long)this.cachePosition;
                skiplen = Math.min(length, avail);
                length -= skiplen;
                this.cachePosition += (int)skiplen;
            }
            if (0L < length) {
                avail = this.archive.length() - this.archive.getFilePointer();
                skiplen = Math.min(avail, length);
                length -= skiplen;
                this.archive.seek(this.archive.getFilePointer() + skiplen);
            }
            return requested - length;
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public void mark(int readLimit) {
            try {
                this.markPosition = this.archive.getFilePointer();
            }
            catch (IOException exception) {
                throw new Error("caught IOException( " + exception.getMessage() + " ) in mark()");
            }
            if (this.markCache == null) {
                this.markCache = (byte[])this.cache.clone();
            } else {
                System.arraycopy(this.cache, 0, this.markCache, 0, this.cacheLimit);
            }
            this.markCacheLimit = this.cacheLimit;
            this.markCachePosition = this.cachePosition;
            this.markPositionIsInCache = true;
        }

        @Override
        public void reset() throws IOException {
            if (this.markPositionIsInCache) {
                this.cachePosition = this.markCachePosition;
            } else {
                if (this.markCache == null) {
                    throw new IOException("not marked.");
                }
                this.archive.seek(this.markPosition);
                System.arraycopy(this.markCache, 0, this.cache, 0, this.markCacheLimit);
                this.cacheLimit = this.markCacheLimit;
                this.cachePosition = this.markCachePosition;
            }
        }

        @Override
        public int available() {
            return this.cacheLimit - this.cachePosition;
        }

        @Override
        public void close() {
            this.archive = null;
            this.cache = null;
            this.cachePosition = 0;
            this.cacheLimit = 0;
            this.markPositionIsInCache = false;
            this.markCache = null;
            this.markCachePosition = 0;
            this.markCacheLimit = 0;
            this.markPosition = 0L;
        }

        public long position() throws IOException {
            long position = this.archive.getFilePointer();
            return position -= (long)(this.cacheLimit - this.cachePosition);
        }

        private void fillCache() throws IOException {
            this.markPositionIsInCache = false;
            this.cacheLimit = 0;
            this.cachePosition = 0;
            int read = 0;
            while (read >= 0 && this.cacheLimit < this.cache.length) {
                read = this.archive.read(this.cache, this.cacheLimit, this.cache.length - this.cacheLimit);
                if (read <= 0) continue;
                this.cacheLimit += read;
            }
        }
    }

    private class HeaderEnumeration
    implements Enumeration {
        private int index = 0;

        @Override
        public boolean hasMoreElements() {
            if (LhaFile.this.archive != null) {
                return this.index < LhaFile.this.headers.size();
            }
            throw new IllegalStateException();
        }

        public Object nextElement() {
            if (LhaFile.this.archive != null) {
                if (this.index < LhaFile.this.headers.size()) {
                    return ((LhaHeader)LhaFile.this.headers.elementAt(this.index++)).clone();
                }
                throw new NoSuchElementException();
            }
            throw new IllegalStateException();
        }
    }

    private class RandomAccessFileInputStream
    extends InputStream {
        private long position;
        private long end;
        private long markPosition;

        public RandomAccessFileInputStream(long start, long size) {
            this.position = start;
            this.end = start + size;
            this.markPosition = -1L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() throws IOException {
            RandomAccessFile randomAccessFile = LhaFile.this.archive;
            synchronized (randomAccessFile) {
                if (this.position < this.end) {
                    int data;
                    if (LhaFile.this.LastAccessObject != this) {
                        LhaFile.this.archive.seek(this.position);
                    }
                    if ((data = LhaFile.this.archive.read()) >= 0) {
                        ++this.position;
                    }
                    return data;
                }
                return -1;
            }
        }

        @Override
        public int read(byte[] buffer) throws IOException {
            return this.read(buffer, 0, buffer.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] buffer, int index, int length) throws IOException {
            RandomAccessFile randomAccessFile = LhaFile.this.archive;
            synchronized (randomAccessFile) {
                if (this.position < this.end) {
                    if (LhaFile.this.LastAccessObject != this) {
                        LhaFile.this.archive.seek(this.position);
                        LhaFile.this.LastAccessObject = this;
                    }
                    length = (int)Math.min(this.end - this.position, (long)length);
                    length = LhaFile.this.archive.read(buffer, index, length);
                    if (length >= 0) {
                        this.position += (long)length;
                    }
                    return length;
                }
                return -1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long skip(long length) {
            RandomAccessFile randomAccessFile = LhaFile.this.archive;
            synchronized (randomAccessFile) {
                long skiplen = Math.min(this.end - this.position, length);
                this.position += skiplen;
                if (LhaFile.this.LastAccessObject == this) {
                    LhaFile.this.LastAccessObject = null;
                }
                return skiplen;
            }
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public void mark(int readLimit) {
            this.markPosition = this.position;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reset() throws IOException {
            RandomAccessFile randomAccessFile = LhaFile.this.archive;
            synchronized (randomAccessFile) {
                if (0L > this.markPosition) {
                    throw new IOException("not marked");
                }
                this.position = this.markPosition;
                if (LhaFile.this.LastAccessObject == this) {
                    LhaFile.this.LastAccessObject = null;
                }
            }
        }

        @Override
        public int available() {
            return 0;
        }

        @Override
        public void close() {
        }
    }
}

